<?php
/**
 * Service Charge Settings Page
 *
 * This file provides the settings page for configuring the service charge percentage.
 *
 * @since      1.0.0
 */

// Set up the page parameters
$page_title = 'Service Charge Settings';
$page_description = 'Configure the service charge percentage and other related settings.';
$option_name = 'service_charge_options';
$option_group = 'service_charge_options';

// Define the fields for the options page
$fields = array(
    array(
        'id' => 'service_charge_percentage',
        'label' => 'Service Charge Percentage',
        'type' => 'number',
        'description' => 'Enter the percentage for the service charge (1-100).',
        'min' => 1,
        'max' => 100,
        'default' => 10
    ),
    array(
        'id' => 'service_charge_description',
        'label' => 'Service Charge Description',
        'type' => 'textarea',
        'description' => 'Enter a description for the service charge that will be displayed to customers.',
        'default' => 'A service charge of {percentage}% will be added to your bill.'
    ),
    array(
        'id' => 'enable_service_charge',
        'label' => 'Enable Service Charge',
        'type' => 'checkbox',
        'description' => 'Check this box to enable the service charge.',
        'default' => true
    )
);

// Include the generic options page template
include_once plugin_dir_path(__FILE__) . 'generic-options-page.php';
?> 