<?php
/**
 * Generic admin header template for the custom plugin system
 *
 * This file provides a reusable header template for admin pages.
 *
 * @since      1.0.0
 */

// Get the page title and description from parameters
$page_title = isset($page_title) ? $page_title : 'service-charge-manager';
$page_description = isset($page_description) ? $page_description : 'service-charge-manager is a plugin that has no description for this page.';
?>

<div class="wrap">
    <div class="custom-admin-header">
        <div class="custom-logo">
            <img src="<?php echo plugin_dir_url(dirname(__FILE__)) . 'images/logo.webp'; ?>" alt="service-charge-manager Logo">
        </div>
        <div class="custom-intro">
            <h1><?php echo esc_html($page_title); ?></h1>
            <p><?php echo esc_html($page_description); ?></p>
        </div>
    </div>
    <div class="custom-admin-content">
        <?php if (isset($content_callback) && is_callable($content_callback)): ?>
            <?php call_user_func($content_callback); ?>
        <?php endif; ?>
    </div>
</div>