<?php
/**
 * Problem: WP Cache
 *
 * Checks if WP_CACHE is enabled.
 *
 * @package Marshal_Mark
 * @since 1.0.0
 */

// If this file is called directly, abort.
if (!defined('ABSPATH')) {
    exit;
}

return array(
    'id' => 'wp_cache',
    'title' => __('WP Cache Disabled', 'marshal-mark'),
    'description' => __('WP_CACHE is not enabled. This can cause performance issues.', 'marshal-mark'),
    'severity' => 'medium',
    'detection' => function($config_content) {
        return preg_match("/define\s*\(\s*['\"]WP_CACHE['\"]\s*,\s*true\s*\)\s*;/i", $config_content);
    },
    'fix' => array(
        'title' => __('Enable WP Cache', 'marshal-mark'),
        'description' => __('Set WP_CACHE to true in wp-config.php.', 'marshal-mark'),
        'code' => "define('WP_CACHE', true);",
        'implementation' => function($config_content) {
            // Check if WP_CACHE is already defined
            if (preg_match("/define\s*\(\s*['\"]WP_CACHE['\"]\s*,/i", $config_content)) {
                // Replace existing definition
                $pattern = "/define\s*\(\s*['\"]WP_CACHE['\"]\s*,\s*false\s*\)\s*;/i";
                $replacement = "define('WP_CACHE', true); /* Marshal Mark: Changed to true */";
                
                $new_content = preg_replace($pattern, $replacement, $config_content);
            } else {
                // Add new definition before "That's all"
                $pattern = "/(\/\* That's all, stop editing! Happy publishing\. \*\/)/i";
                $replacement = "define('WP_CACHE', true); /* Marshal Mark: Added */\n\n$1";
                
                $new_content = preg_replace($pattern, $replacement, $config_content);
            }
            
            return $new_content;
        }
    )
); 