<?php
/**
 * Problem: Script Concatenation
 *
 * Checks if CONCATENATE_SCRIPTS is disabled.
 *
 * @package Marshal_Mark
 * @since 1.0.0
 */

// If this file is called directly, abort.
if (!defined('ABSPATH')) {
    exit;
}

return array(
    'id' => 'script_concatenation',
    'title' => __('Script Concatenation Disabled', 'marshal-mark'),
    'description' => __('CONCATENATE_SCRIPTS is set to false. This can slow down admin pages by loading many individual script files.', 'marshal-mark'),
    'severity' => 'low', // Low severity - admin performance issue
    'detection' => function($config_content) {
        return preg_match("/define\s*\(\s*['\"]CONCATENATE_SCRIPTS['\"]\s*,\s*false\s*\)\s*;/i", $config_content);
    },
    'fix' => array(
        'title' => __('Enable Script Concatenation', 'marshal-mark'),
        'description' => __('Remove the CONCATENATE_SCRIPTS definition to use the default (true).', 'marshal-mark'),
        'code' => "// CONCATENATE_SCRIPTS definition removed",
        'implementation' => function($config_content) {
            // Remove the definition
            $pattern = "/define\s*\(\s*['\"]CONCATENATE_SCRIPTS['\"]\s*,\s*false\s*\)\s*;\s*\n?/i";
            $replacement = "/* Marshal Mark: Removed CONCATENATE_SCRIPTS definition to use default (true) */\n";
            
            return preg_replace($pattern, $replacement, $config_content);
        }
    )
); 