<?php
/**
 * Problem: Memory Limit
 *
 * Checks if WP_MEMORY_LIMIT is set to a sufficient value.
 *
 * @package Marshal_Mark
 * @since 1.0.0
 */

// If this file is called directly, abort.
if (!defined('ABSPATH')) {
    exit;
}

return array(
    'id' => 'memory_limit',
    'title' => __('Low Memory Limit', 'marshal-mark'),
    'description' => __('WP_MEMORY_LIMIT is set to less than 64M or not defined. This can cause performance issues.', 'marshal-mark'),
    'severity' => 'medium', // Medium severity - can cause performance issues
    'detection' => function($config_content) {
        // Check if WP_MEMORY_LIMIT is defined with a sufficient value
        if (preg_match("/define\s*\(\s*['\"]WP_MEMORY_LIMIT['\"]\s*,\s*['\"](\d+)M['\"]\s*\)\s*;/i", $config_content, $matches)) {
            $limit = (int) $matches[1];
            return $limit < 64;
        }
        
        // Not defined at all
        return true;
    },
    'fix' => array(
        'title' => __('Increase Memory Limit', 'marshal-mark'),
        'description' => __('Set WP_MEMORY_LIMIT to 128M in wp-config.php.', 'marshal-mark'),
        'code' => "define('WP_MEMORY_LIMIT', '128M');",
        'implementation' => function($config_content) {
            // Check if WP_MEMORY_LIMIT is already defined
            if (preg_match("/define\s*\(\s*['\"]WP_MEMORY_LIMIT['\"]\s*,/i", $config_content)) {
                // Replace existing definition
                $pattern = "/define\s*\(\s*['\"]WP_MEMORY_LIMIT['\"]\s*,\s*['\"].*?['\"]\s*\)\s*;/i";
                $replacement = "define('WP_MEMORY_LIMIT', '128M'); /* Marshal Mark: Changed to 128M */";
                
                $new_content = preg_replace($pattern, $replacement, $config_content);
            } else {
                // Add new definition before "That's all"
                $pattern = "/(\/\* That's all, stop editing! Happy publishing\. \*\/)/i";
                $replacement = "define('WP_MEMORY_LIMIT', '128M'); /* Marshal Mark: Added */\n\n$1";
                
                $new_content = preg_replace($pattern, $replacement, $config_content);
            }
            
            return $new_content;
        }
    )
); 