<?php
/**
 * Problem: FS Method
 *
 * Checks if FS_METHOD is set to direct.
 *
 * @package Marshal_Mark
 * @since 1.0.0
 */

// If this file is called directly, abort.
if (!defined('ABSPATH')) {
    exit;
}

return array(
    'id' => 'fs_method',
    'title' => __('FS_METHOD Not Set to Direct', 'marshal-mark'),
    'description' => __('FS_METHOD is not set to "direct". This may cause issues with plugin and theme installations.', 'marshal-mark'),
    'severity' => 'low', // Low severity - mostly a convenience issue
    'detection' => function($config_content) {
        return !preg_match("/define\s*\(\s*['\"]FS_METHOD['\"]\s*,\s*['\"]direct['\"]\s*\)\s*;/i", $config_content);
    },
    'fix' => array(
        'title' => __('Set FS_METHOD to Direct', 'marshal-mark'),
        'description' => __('Set FS_METHOD to "direct" in wp-config.php.', 'marshal-mark'),
        'code' => "define('FS_METHOD', 'direct');",
        'implementation' => function($config_content) {
            // Check if FS_METHOD is already defined
            if (preg_match("/define\s*\(\s*['\"]FS_METHOD['\"]\s*,/i", $config_content)) {
                // Replace existing definition
                $pattern = "/define\s*\(\s*['\"]FS_METHOD['\"]\s*,\s*['\"].*?['\"]\s*\)\s*;/i";
                $replacement = "define('FS_METHOD', 'direct'); /* Marshal Mark: Changed to direct */";
                
                $new_content = preg_replace($pattern, $replacement, $config_content);
            } else {
                // Add new definition before "That's all"
                $pattern = "/(\/\* That's all, stop editing! Happy publishing\. \*\/)/i";
                $replacement = "define('FS_METHOD', 'direct'); /* Marshal Mark: Added */\n\n$1";
                
                $new_content = preg_replace($pattern, $replacement, $config_content);
            }
            
            return $new_content;
        }
    )
); 