<?php
/**
 * Problem: Empty Trash Days
 *
 * Checks if EMPTY_TRASH_DAYS is set to a reasonable value.
 *
 * @package Marshal_Mark
 * @since 1.0.0
 */

// If this file is called directly, abort.
if (!defined('ABSPATH')) {
    exit;
}

return array(
    'id' => 'empty_trash_days',
    'title' => __('Trash Retention Too Long', 'marshal-mark'),
    'description' => __('EMPTY_TRASH_DAYS is set to more than 30 days or not defined. This can lead to database bloat.', 'marshal-mark'),
    'severity' => 'low', // Low severity - minor performance impact
    'detection' => function($config_content) {
        // Check if EMPTY_TRASH_DAYS is defined with a reasonable value
        if (preg_match("/define\s*\(\s*['\"]EMPTY_TRASH_DAYS['\"]\s*,\s*(\d+)\s*\)\s*;/i", $config_content, $matches)) {
            $days = (int) $matches[1];
            return $days > 30 || $days <= 0;
        }
        
        // Not defined at all
        return true;
    },
    'fix' => array(
        'title' => __('Set Reasonable Trash Retention', 'marshal-mark'),
        'description' => __('Set EMPTY_TRASH_DAYS to 7 in wp-config.php.', 'marshal-mark'),
        'code' => "define('EMPTY_TRASH_DAYS', 7);",
        'implementation' => function($config_content) {
            // Check if EMPTY_TRASH_DAYS is already defined
            if (preg_match("/define\s*\(\s*['\"]EMPTY_TRASH_DAYS['\"]\s*,/i", $config_content)) {
                // Replace existing definition
                $pattern = "/define\s*\(\s*['\"]EMPTY_TRASH_DAYS['\"]\s*,\s*\d+\s*\)\s*;/i";
                $replacement = "define('EMPTY_TRASH_DAYS', 7); /* Marshal Mark: Changed to 7 days */";
                
                $new_content = preg_replace($pattern, $replacement, $config_content);
            } else {
                // Add new definition before "That's all"
                $pattern = "/(\/\* That's all, stop editing! Happy publishing\. \*\/)/i";
                $replacement = "define('EMPTY_TRASH_DAYS', 7); /* Marshal Mark: Added */\n\n$1";
                
                $new_content = preg_replace($pattern, $replacement, $config_content);
            }
            
            return $new_content;
        }
    )
); 