<?php
/**
 * Problem: Disallow File Mods
 *
 * Checks if DISALLOW_FILE_MODS is enabled.
 *
 * @package Marshal_Mark
 * @since 1.0.0
 */

// If this file is called directly, abort.
if (!defined('ABSPATH')) {
    exit;
}

return array(
    'id' => 'disallow_file_mods',
    'title' => __('File Modifications Enabled', 'marshal-mark'),
    'description' => __('DISALLOW_FILE_MODS is not set to true. This allows users to install and update plugins and themes.', 'marshal-mark'),
    'severity' => 'medium', // Medium severity - can be a security risk but also needed for updates
    'detection' => function($config_content) {
        return !preg_match("/define\s*\(\s*['\"]DISALLOW_FILE_MODS['\"]\s*,\s*true\s*\)\s*;/i", $config_content);
    },
    'fix' => array(
        'title' => __('Disable File Modifications', 'marshal-mark'),
        'description' => __('Set DISALLOW_FILE_MODS to true in wp-config.php.', 'marshal-mark'),
        'code' => "define('DISALLOW_FILE_MODS', true);",
        'implementation' => function($config_content) {
            // Check if DISALLOW_FILE_MODS is already defined
            if (preg_match("/define\s*\(\s*['\"]DISALLOW_FILE_MODS['\"]\s*,/i", $config_content)) {
                // Replace existing definition
                $pattern = "/define\s*\(\s*['\"]DISALLOW_FILE_MODS['\"]\s*,\s*(false|0)\s*\)\s*;/i";
                $replacement = "define('DISALLOW_FILE_MODS', true); /* Marshal Mark: Changed from false to true */";
                
                $new_content = preg_replace($pattern, $replacement, $config_content);
            } else {
                // Add new definition before "That's all"
                $pattern = "/(\/\* That's all, stop editing! Happy publishing\. \*\/)/i";
                $replacement = "define('DISALLOW_FILE_MODS', true); /* Marshal Mark: Added */\n\n$1";
                
                $new_content = preg_replace($pattern, $replacement, $config_content);
            }
            
            return $new_content;
        }
    )
); 