<?php
/**
 * Problem: Disallow File Edit
 *
 * Checks if DISALLOW_FILE_EDIT is enabled.
 *
 * @package Marshal_Mark
 * @since 1.0.0
 */

// If this file is called directly, abort.
if (!defined('ABSPATH')) {
    exit;
}

return array(
    'id' => 'disallow_file_edit',
    'title' => __('File Editing Enabled', 'marshal-mark'),
    'description' => __('DISALLOW_FILE_EDIT is not set to true. This allows users to edit plugin and theme files from the WordPress admin.', 'marshal-mark'),
    'severity' => 'high', // High severity - security risk allowing code modification
    'detection' => function($config_content) {
        return !preg_match("/define\s*\(\s*['\"]DISALLOW_FILE_EDIT['\"]\s*,\s*true\s*\)\s*;/i", $config_content);
    },
    'fix' => array(
        'title' => __('Disable File Editing', 'marshal-mark'),
        'description' => __('Set DISALLOW_FILE_EDIT to true in wp-config.php.', 'marshal-mark'),
        'code' => "define('DISALLOW_FILE_EDIT', true);",
        'implementation' => function($config_content) {
            // Check if DISALLOW_FILE_EDIT is already defined
            if (preg_match("/define\s*\(\s*['\"]DISALLOW_FILE_EDIT['\"]\s*,/i", $config_content)) {
                // Replace existing definition
                $pattern = "/define\s*\(\s*['\"]DISALLOW_FILE_EDIT['\"]\s*,\s*(false|0)\s*\)\s*;/i";
                $replacement = "define('DISALLOW_FILE_EDIT', true); /* Marshal Mark: Changed from false to true */";
                
                $new_content = preg_replace($pattern, $replacement, $config_content);
            } else {
                // Add new definition before "That's all"
                $pattern = "/(\/\* That's all, stop editing! Happy publishing\. \*\/)/i";
                $replacement = "define('DISALLOW_FILE_EDIT', true); /* Marshal Mark: Added */\n\n$1";
                
                $new_content = preg_replace($pattern, $replacement, $config_content);
            }
            
            return $new_content;
        }
    )
); 