<?php
/**
 * Problem: Disable WP Cron
 *
 * Checks if DISABLE_WP_CRON is enabled.
 *
 * @package Marshal_Mark
 * @since 1.0.0
 */

// If this file is called directly, abort.
if (!defined('ABSPATH')) {
    exit;
}

return array(
    'id' => 'disable_wp_cron',
    'title' => __('WordPress Cron Enabled', 'marshal-mark'),
    'description' => __('DISABLE_WP_CRON is not set to true. WordPress cron can cause performance issues on high-traffic sites.', 'marshal-mark'),
    'severity' => 'low',
    'detection' => function($config_content) {
        return !preg_match("/define\s*\(\s*['\"]DISABLE_WP_CRON['\"]\s*,\s*true\s*\)\s*;/i", $config_content);
    },
    'fix' => array(
        'title' => __('Disable WordPress Cron', 'marshal-mark'),
        'description' => __('Set DISABLE_WP_CRON to true in wp-config.php and set up a server cron job instead.', 'marshal-mark'),
        'code' => "define('DISABLE_WP_CRON', true);",
        'implementation' => function($config_content) {
            // Check if DISABLE_WP_CRON is already defined
            if (preg_match("/define\s*\(\s*['\"]DISABLE_WP_CRON['\"]\s*,/i", $config_content)) {
                // Replace existing definition
                $pattern = "/define\s*\(\s*['\"]DISABLE_WP_CRON['\"]\s*,\s*false\s*\)\s*;/i";
                $replacement = "define('DISABLE_WP_CRON', true); /* Marshal Mark: Changed from false to true */";
                
                $new_content = preg_replace($pattern, $replacement, $config_content);
            } else {
                // Add new definition before "That's all"
                $pattern = "/(\/\* That's all, stop editing! Happy publishing\. \*\/)/i";
                $replacement = "define('DISABLE_WP_CRON', true); /* Marshal Mark: Added */\n\n$1";
                
                $new_content = preg_replace($pattern, $replacement, $config_content);
            }
            
            return $new_content;
        }
    )
); 