<?php
/**
 * Problem: Debug Test
 *
 * This is a test problem that is always detected when debug mode is enabled.
 * It's used to verify that the problem loading mechanism is working.
 *
 * @package Marshal_Mark
 * @since 1.0.0
 */

// If this file is called directly, abort.
if (!defined('ABSPATH')) {
    exit;
}

return array(
    'id' => 'debug_test',
    'title' => __('Debug Test Problem', 'marshal-mark'),
    'description' => __('This is a test problem that is always detected when debug mode is enabled. If you see this, the problem loading mechanism is working correctly.', 'marshal-mark'),
    'severity' => 'low',
    'detection' => function($config_content) {
        // Only detect this problem if debug mode is enabled
        $options = get_option('marshal_mark_settings');
        $debug_mode = isset($options['debug_mode']) ? $options['debug_mode'] : false;
        
        return $debug_mode;
    },
    'fix' => array(
        'title' => __('Fix Debug Test', 'marshal-mark'),
        'description' => __('This is a dummy fix that doesn\'t actually change anything.', 'marshal-mark'),
        'code' => "// This is a dummy fix",
        'implementation' => function($config_content) {
            // Just return the original content unchanged
            return $config_content;
        }
    )
); 