<?php
/**
 * Problem: Debug Mode
 *
 * Checks if WP_DEBUG is enabled in production.
 *
 * @package Marshal_Mark
 * @since 1.0.0
 */

// If this file is called directly, abort.
if (!defined('ABSPATH')) {
    exit;
}

return array(
    'id' => 'debug_mode',
    'title' => __('Debug Mode Enabled', 'marshal-mark'),
    'description' => __('WP_DEBUG is set to true. This should be disabled in production environments.', 'marshal-mark'),
    'severity' => 'high',
    'detection' => function($config_content) {
        return preg_match("/define\s*\(\s*['\"]WP_DEBUG['\"]\s*,\s*true\s*\)\s*;/i", $config_content);
    },
    'fix' => array(
        'title' => __('Disable Debug Mode', 'marshal-mark'),
        'description' => __('Set WP_DEBUG to false in wp-config.php.', 'marshal-mark'),
        'code' => "define('WP_DEBUG', false);",
        'implementation' => function($config_content) {
            $pattern = "/define\s*\(\s*['\"]WP_DEBUG['\"]\s*,\s*true\s*\)\s*;/i";
            $replacement = "define('WP_DEBUG', false); /* Marshal Mark: Changed from true to false */";
            
            return preg_replace($pattern, $replacement, $config_content);
        }
    )
); 