<?php
/**
 * Problem: Debug Log
 *
 * Checks if WP_DEBUG_LOG is enabled when WP_DEBUG is enabled.
 *
 * @package Marshal_Mark
 * @since 1.0.0
 */

// If this file is called directly, abort.
if (!defined('ABSPATH')) {
    exit;
}

return array(
    'id' => 'debug_log',
    'title' => __('Debug Log Disabled', 'marshal-mark'),
    'description' => __('WP_DEBUG is enabled but WP_DEBUG_LOG is not. It\'s recommended to log errors instead of displaying them.', 'marshal-mark'),
    'severity' => 'medium',
    'detection' => function($config_content) {
        // Only a problem if WP_DEBUG is enabled but WP_DEBUG_LOG is not
        $debug_enabled = preg_match("/define\s*\(\s*['\"]WP_DEBUG['\"]\s*,\s*true\s*\)\s*;/i", $config_content);
        $debug_log_enabled = preg_match("/define\s*\(\s*['\"]WP_DEBUG_LOG['\"]\s*,\s*true\s*\)\s*;/i", $config_content);
        
        return $debug_enabled && !$debug_log_enabled;
    },
    'fix' => array(
        'title' => __('Enable Debug Log', 'marshal-mark'),
        'description' => __('Set WP_DEBUG_LOG to true in wp-config.php.', 'marshal-mark'),
        'code' => "define('WP_DEBUG_LOG', true);",
        'implementation' => function($config_content) {
            // Check if WP_DEBUG_LOG is already defined
            if (preg_match("/define\s*\(\s*['\"]WP_DEBUG_LOG['\"]\s*,/i", $config_content)) {
                // Replace existing definition
                $pattern = "/define\s*\(\s*['\"]WP_DEBUG_LOG['\"]\s*,\s*(false|0)\s*\)\s*;/i";
                $replacement = "define('WP_DEBUG_LOG', true); /* Marshal Mark: Changed from false to true */";
                
                $new_content = preg_replace($pattern, $replacement, $config_content);
            } else {
                // Add new definition after WP_DEBUG
                $pattern = "/(define\s*\(\s*['\"]WP_DEBUG['\"]\s*,\s*.*?\)\s*;)/i";
                $replacement = "$1\ndefine('WP_DEBUG_LOG', true); /* Marshal Mark: Added */";
                
                $new_content = preg_replace($pattern, $replacement, $config_content);
            }
            
            return $new_content;
        }
    )
); 