<?php
/**
 * Problem: Debug Display
 *
 * Checks if WP_DEBUG_DISPLAY is enabled when WP_DEBUG is enabled.
 *
 * @package Marshal_Mark
 * @since 1.0.0
 */

// If this file is called directly, abort.
if (!defined('ABSPATH')) {
    exit;
}

return array(
    'id' => 'debug_display',
    'title' => __('Debug Display Enabled', 'marshal-mark'),
    'description' => __('WP_DEBUG_DISPLAY is set to true. This should be disabled in production environments.', 'marshal-mark'),
    'severity' => 'high', // High severity - can expose sensitive information to visitors
    'detection' => function($config_content) {
        // Only a problem if WP_DEBUG is enabled and WP_DEBUG_DISPLAY is not explicitly disabled
        $debug_enabled = preg_match("/define\s*\(\s*['\"]WP_DEBUG['\"]\s*,\s*true\s*\)\s*;/i", $config_content);
        $debug_display_disabled = preg_match("/define\s*\(\s*['\"]WP_DEBUG_DISPLAY['\"]\s*,\s*false\s*\)\s*;/i", $config_content);
        
        return $debug_enabled && !$debug_display_disabled;
    },
    'fix' => array(
        'title' => __('Disable Debug Display', 'marshal-mark'),
        'description' => __('Set WP_DEBUG_DISPLAY to false in wp-config.php.', 'marshal-mark'),
        'code' => "define('WP_DEBUG_DISPLAY', false);",
        'implementation' => function($config_content) {
            // Check if WP_DEBUG_DISPLAY is already defined
            if (preg_match("/define\s*\(\s*['\"]WP_DEBUG_DISPLAY['\"]\s*,/i", $config_content)) {
                // Replace existing definition
                $pattern = "/define\s*\(\s*['\"]WP_DEBUG_DISPLAY['\"]\s*,\s*(true|1)\s*\)\s*;/i";
                $replacement = "define('WP_DEBUG_DISPLAY', false); /* Marshal Mark: Changed from true to false */";
                
                $new_content = preg_replace($pattern, $replacement, $config_content);
            } else {
                // Add new definition after WP_DEBUG
                $pattern = "/(define\s*\(\s*['\"]WP_DEBUG['\"]\s*,\s*.*?\)\s*;)/i";
                $replacement = "$1\ndefine('WP_DEBUG_DISPLAY', false); /* Marshal Mark: Added */";
                
                $new_content = preg_replace($pattern, $replacement, $config_content);
            }
            
            return $new_content;
        }
    )
); 