<?php
/**
 * Problem: Autosave Interval
 *
 * Checks if AUTOSAVE_INTERVAL is set to a reasonable value.
 *
 * @package Marshal_Mark
 * @since 1.0.0
 */

// If this file is called directly, abort.
if (!defined('ABSPATH')) {
    exit;
}

return array(
    'id' => 'autosave_interval',
    'title' => __('Autosave Interval Too Short', 'marshal-mark'),
    'description' => __('AUTOSAVE_INTERVAL is set to less than 60 seconds. This can cause excessive server requests.', 'marshal-mark'),
    'severity' => 'low', // Low severity - minor performance impact
    'detection' => function($config_content) {
        // Check if AUTOSAVE_INTERVAL is defined with a reasonable value
        if (preg_match("/define\s*\(\s*['\"]AUTOSAVE_INTERVAL['\"]\s*,\s*(\d+)\s*\)\s*;/i", $config_content, $matches)) {
            $seconds = (int) $matches[1];
            return $seconds < 60;
        }
        
        // Default is 60, so not a problem if not defined
        return false;
    },
    'fix' => array(
        'title' => __('Set Reasonable Autosave Interval', 'marshal-mark'),
        'description' => __('Set AUTOSAVE_INTERVAL to 120 seconds in wp-config.php.', 'marshal-mark'),
        'code' => "define('AUTOSAVE_INTERVAL', 120);",
        'implementation' => function($config_content) {
            // Check if AUTOSAVE_INTERVAL is already defined
            if (preg_match("/define\s*\(\s*['\"]AUTOSAVE_INTERVAL['\"]\s*,/i", $config_content)) {
                // Replace existing definition
                $pattern = "/define\s*\(\s*['\"]AUTOSAVE_INTERVAL['\"]\s*,\s*\d+\s*\)\s*;/i";
                $replacement = "define('AUTOSAVE_INTERVAL', 120); /* Marshal Mark: Changed to 120 seconds */";
                
                $new_content = preg_replace($pattern, $replacement, $config_content);
            } else {
                // Add new definition before "That's all"
                $pattern = "/(\/\* That's all, stop editing! Happy publishing\. \*\/)/i";
                $replacement = "define('AUTOSAVE_INTERVAL', 120); /* Marshal Mark: Added */\n\n$1";
                
                $new_content = preg_replace($pattern, $replacement, $config_content);
            }
            
            return $new_content;
        }
    )
); 