<?php
/**
 * Problem: Auto Update Core
 *
 * Checks if WP_AUTO_UPDATE_CORE is enabled.
 *
 * @package Marshal_Mark
 * @since 1.0.0
 */

// If this file is called directly, abort.
if (!defined('ABSPATH')) {
    exit;
}

return array(
    'id' => 'auto_update_core',
    'title' => __('Core Auto-Updates Disabled', 'marshal-mark'),
    'description' => __('WP_AUTO_UPDATE_CORE is not set to true. This prevents WordPress from automatically updating to minor releases.', 'marshal-mark'),
    'severity' => 'medium', // Medium severity - security updates are important
    'detection' => function($config_content) {
        return !preg_match("/define\s*\(\s*['\"]WP_AUTO_UPDATE_CORE['\"]\s*,\s*(true|['\"]minor['\"])\s*\)\s*;/i", $config_content);
    },
    'fix' => array(
        'title' => __('Enable Core Auto-Updates', 'marshal-mark'),
        'description' => __('Set WP_AUTO_UPDATE_CORE to true in wp-config.php.', 'marshal-mark'),
        'code' => "define('WP_AUTO_UPDATE_CORE', true);",
        'implementation' => function($config_content) {
            // Check if WP_AUTO_UPDATE_CORE is already defined
            if (preg_match("/define\s*\(\s*['\"]WP_AUTO_UPDATE_CORE['\"]\s*,/i", $config_content)) {
                // Replace existing definition
                $pattern = "/define\s*\(\s*['\"]WP_AUTO_UPDATE_CORE['\"]\s*,\s*(false|0|['\"]disabled['\"])\s*\)\s*;/i";
                $replacement = "define('WP_AUTO_UPDATE_CORE', true); /* Marshal Mark: Changed to enable auto updates */";
                
                $new_content = preg_replace($pattern, $replacement, $config_content);
            } else {
                // Add new definition before "That's all"
                $pattern = "/(\/\* That's all, stop editing! Happy publishing\. \*\/)/i";
                $replacement = "define('WP_AUTO_UPDATE_CORE', true); /* Marshal Mark: Added */\n\n$1";
                
                $new_content = preg_replace($pattern, $replacement, $config_content);
            }
            
            return $new_content;
        }
    )
); 