# Marshal Mark - WordPress Configuration Analyzer

Marshal Mark is a WordPress plugin that acts as a configuration best practice enforcement officer for your WordPress site. It helps identify and fix common issues in your wp-config.php file to ensure your site runs securely and efficiently.

## Features

- **WP Config Analysis**: Automatically analyzes your wp-config.php file for common issues and best practices.
- **Automated Fixes**: One-click solutions to fix detected configuration issues.
- **Config Injection**: Injects itself into wp-config.php. Keeps edited configurations neat and organized.
- **Backup System**: Creates backups of your wp-config.php file before making any changes.
- **Admin-Only Interface**: All functionality is contained within the WordPress admin area.
- **Database Optimization**: Cleans up excess post revisions to improve database performance.

## How It Works

1. **Analysis**: It analyzes your WordPress configuration for common issues and best practices.
2. **Recommendations**: It provides recommendations for fixing detected issues.
3. **Fixes**: It can automatically fix issues by adding or modifying constants in the configuration file.

## Issues Detected

Marshal Mark can detect and fix the following issues:

- Debug mode enabled in production
- Debug logging enabled
- Debug display enabled
- Script debugging enabled
- Save queries enabled
- Weak authentication keys and salts
- Automatic updates disabled
- Low memory limit
- **Unlimited post revisions** (with database cleanup)
- File editing enabled in admin

## Post Revisions Management

One of the key features of Marshal Mark is its ability to manage post revisions:

1. **Detection**: The plugin detects if your WordPress installation has unlimited post revisions enabled.
2. **Analysis**: It analyzes your database to count how many excess revisions exist.
3. **Configuration**: It sets a reasonable limit (10 revisions per post) in your wp-config.php file.
4. **Cleanup**: It automatically removes excess revisions from your database, keeping only the 10 most recent revisions per post.

This feature can significantly improve database performance on sites with many posts and revisions.

## Installation

1. Upload the `marshal-mark` folder to the `/wp-content/plugins/` directory
2. Activate the plugin through the 'Plugins' menu in WordPress
3. Navigate to the 'Marshal Mark' menu in your admin dashboard
4. Click "Inject Marshal Mark" to add the include statement to your wp-config.php file
5. Analyze your configuration and fix any detected issues

## Usage

### Configuration Analysis

The main screen shows an analysis of your wp-config.php file, highlighting any issues that were detected:

1. View the status of your wp-config.php file and the Marshal Mark configuration
2. Click "Analyze Now" to perform a fresh analysis
3. Review the list of detected issues
4. Click "Fix Now" next to an issue to apply the recommended fix
5. Alternatively, click "Fix All Issues" to fix all detected issues at once

### Settings

Configure the plugin behavior in the Settings tab:

- Enable/disable automatic fixing of issues
- Enable/disable email notifications
- Enable/disable configuration backups

### Backups

The plugin automatically creates backups of your wp-config.php file before making any changes. You can view and restore these backups from the Settings page.

## Frequently Asked Questions

**Q: Is it safe to let Marshal Mark modify my wp-config.php file?**
A: Yes, Marshal Mark creates backups of your wp-config.php file before making any changes, so you can always restore a previous version if needed.

**Q: Will this plugin slow down my site?**
A: No, Marshal Mark only runs in the WordPress admin area and doesn't add any code to your front-end site.

**Q: Is it safe to delete post revisions?**
A: Yes, the plugin only deletes excess revisions, keeping the 10 most recent revisions for each post. This ensures you still have a history of changes while improving database performance.

**Q: What happens if something goes wrong during injection?**
A: Marshal Mark will display an error message and won't make any changes to your wp-config.php file.

## Changelog

### 1.0.0
* Initial release

## Credits

Marshal Mark is developed and maintained by Jabybaby.