<?php

/**
 * Provide a admin area view for the plugin's settings page
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @since      1.0.0
 */

// Set up the header parameters
$page_title = 'Forklift Settings';
$page_description = 'Configure your warehouse connection settings.';

// Save settings if form is submitted
if (isset($_POST['submit_forklift_settings'])) {
    if (check_admin_referer('forklift_settings_nonce', 'forklift_settings_nonce')) {
        update_option('forklift_warehouse_url', sanitize_url($_POST['warehouse_url']));
        update_option('forklift_api_key', sanitize_text_field($_POST['api_key']));
        $settings_saved = true;
    }
}

// Get current settings
$warehouse_url = get_option('forklift_warehouse_url', '');
$api_key = get_option('forklift_api_key', '');

// Define the content callback function
function render_settings_content() {
    // Get the settings directly in this function
    $warehouse_url = get_option('forklift_warehouse_url', '');
    $api_key = get_option('forklift_api_key', '');
    global $settings_saved;
    ?>
    <div class="wrap">
        <?php if (isset($settings_saved) && $settings_saved): ?>
            <div class="notice notice-success is-dismissible">
                <p><?php _e('Settings saved successfully!', 'forklift'); ?></p>
            </div>
        <?php endif; ?>

        <form method="post" autocomplete="off">
            <!-- Hidden fields to prevent autofill -->
            <input type="text" style="display:none" name="fakeusernameremembered"/>
            <input type="password" style="display:none" name="fakepasswordremembered"/>
            
            <?php wp_nonce_field('forklift_settings_nonce', 'forklift_settings_nonce'); ?>
            <table class="form-table">
                <tr valign="top">
                    <th scope="row">
                        <label for="warehouse_url"><?php _e('Warehouse URL', 'forklift'); ?></label>
                    </th>
                    <td>
                        <input type="url" id="warehouse_url" name="warehouse_url" class="regular-text" 
                               value="<?php echo esc_attr($warehouse_url); ?>" placeholder="https://warehouse.example.com/api" autocomplete="new-password" />
                        <p class="description"><?php _e('Enter the URL of your warehouse API endpoint.', 'forklift'); ?></p>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="api_key"><?php _e('API Key', 'forklift'); ?></label>
                    </th>
                    <td>
                        <input type="password" id="api_key" name="api_key" class="regular-text" 
                               value="<?php echo esc_attr($api_key); ?>" autocomplete="new-password" />
                        <p class="description"><?php _e('Enter your API key for bearer authentication.', 'forklift'); ?></p>
                    </td>
                </tr>
            </table>
            <p class="submit">
                <input type="submit" name="submit_forklift_settings" class="button button-primary" value="<?php _e('Save Settings', 'forklift'); ?>" />
            </p>
        </form>
    </div>
    <?php
}

// Set the content callback
$content_callback = 'render_settings_content';

// Include the header template
include_once plugin_dir_path(__FILE__) . 'custom-header.php';
?>

</script> 