<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @since      1.0.0
 */
class Forklift_Admin {

    /**
     * The ID of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string    $plugin_name    The ID of this plugin.
     */
    private $plugin_name;

    /**
     * The version of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string    $version    The current version of this plugin.
     */
    private $version;

   
    /**
     * Initialize the class and set its properties.
     *
     * @since    1.0.0
     * @param      string    $plugin_name       The name of this plugin.
     * @param      string    $version    The version of this plugin.
     */
    public function __construct( $plugin_name, $version ) {

        $this->plugin_name = $plugin_name;
        $this->version = $version;
    }
    /**
     * Register the stylesheets for the admin area.
     *
     * @since    1.0.0
     */
    public function enqueue_styles() {
        wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/custom-admin.css', array(), $this->version, 'all' );
        
        // Add inline CSS to hide the default admin title
        $current_screen = get_current_screen();
        if (isset($current_screen->id) && 
            (strpos($current_screen->id, 'forklift') !== false || 
             strpos($current_screen->id, 'toplevel_page_forklift') !== false)) {
            
            wp_add_inline_style($this->plugin_name, '
                body.toplevel_page_forklift h1.wp-heading-inline:not(.custom-intro h1),
                body.toplevel_page_forklift .wrap > h1:not(.custom-intro h1),
                body.forklift_page_custom-settings h1.wp-heading-inline:not(.custom-intro h1),
                body.forklift_page_custom-settings .wrap > h1:not(.custom-intro h1) {
                    display: none !important;
                }
                
                .custom-intro h1 {
                    display: block !important;
                }
            ');
        }
    }

    /**
     * Add an options page under the Settings submenu
     *
     * @since  1.0.0
     */
    public function add_plugin_admin_menu() {
        
        add_menu_page(
            __( 'Forklift', 'forklift' ),
            __( 'Forklift', 'forklift' ),
            'manage_options',
            $this->plugin_name,
            array( $this, 'display_settings_page' ),
            'dashicons-admin-generic',
            100
        );
    }

    /**
     * Render the settings page.
     *
     * @since    1.0.0
     */
    public function display_settings_page() {
        include_once( 'partials/settings-page.php' );
    }
} 