<?php
/**
 * Plugin Name: SmartBits Developer Toolkit
 * Plugin URI: https://notbugjustfeature.com/developer-toolkit
 * Description: This plugin has handy tools for developers. Currently it only has a tool to view all the hooks and what uses them, including their priority and function body.
 * Version: 1.2.15
 * Author: NotBugJustFeature
 * Author URI: https://notbugjustfeature.com
 * Text Domain: developer-toolkit
 * Update URI: https://warehouse.wp.dev3.smartbits.hu/plugins/developer-toolkit
 */
// If this file is called directly, abort.
if (!defined('ABSPATH')) {
    exit;
}

// Define the main plugin file path constant
if (!defined('Developer_Toolkit_FILE')) {
    define('Developer_Toolkit_FILE', __FILE__);
}

// Include the auto-update functionality
require_once plugin_dir_path(__FILE__) . 'auto-updates.php';

// Initialize auto-update functionality
Developer_Toolkit_Auto_Updates::init();

// Define plugin constants
define('Developer_Toolkit_VERSION', '1.2.15');
define('Developer_Toolkit_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('Developer_Toolkit_PLUGIN_URL', plugin_dir_url(__FILE__));

/**
 * The core plugin class
 */
class Developer_Toolkit {

    /**
     * The unique instance of the plugin.
     *
     * @var Developer_Toolkit
     */
    private static $instance;

    /**
     * Gets an instance of the plugin.
     *
     * @return Developer_Toolkit
     */
    public static function get_instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    /**
     * Constructor.
     */
    private function __construct() {
        $this->load_dependencies();
        $this->define_admin_hooks();
    }

    /**
     * Load the required dependencies for this plugin.
     */
    private function load_dependencies() {
        // Include the admin class
        require_once Developer_Toolkit_PLUGIN_DIR . 'admin/class-custom-admin.php';
    }

    /**
     * Register all of the hooks related to the admin area functionality.
     */
    private function define_admin_hooks() {
        $plugin_admin = new Developer_Toolkit_Admin('developer-toolkit', '1.2.15');
        
        // Add admin menu
        add_action('admin_menu', array($plugin_admin, 'add_plugin_admin_menu'));
                
        // Register admin styles and scripts
        add_action('admin_enqueue_scripts', array($plugin_admin, 'enqueue_styles'));
    }
}

// Initialize the plugin
Developer_Toolkit::get_instance(); 